Imports MelissaData

'********************************************************************************
'If you should have any comments, suggestions or improvements to these samples, 
'we welcome you to contact us at SampleCode@melissadata.com also please visit our 
'developers bulletin board at forum.melissadata.com.
'********************************************************************************

Public Class Form1
    'Creating objects
    Dim addrObj As New mdAddr
    Dim parseObj As New mdParse
    Dim streetObj As New mdStreet
    Dim zipObj As New mdZip
    Dim parseFlag = 0


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' ********************** LICENSE STRINGS ***********************
        '       To unlock the full function ality of Address Object,   
        '   please call a sales representative at 1-800-MELISSA ext. 3 
        '           (1-800-635-4772 x3) for a license string.          
        '        Without a valid license string, AddressCheck will     
        '                  only verify Nevada addresses.               
        '              REPLACE "DEMO" with LICENSE STRING                    

        '   SetLicenseString will also check for a valid license in the 
        '   MDADDR_LICENSE(Environment) variable. This allows you to  
        '   modify the license without recompiling the project
        ' **************************************************************
        Const dLICENSE = "DEMO"

        ' ********************** DATA FILE PATH  ***********************
        ' File location path is set to the default Data File location. *
        ' Change this value if you installed the data files to a       *
        ' different folder.                                            *
        ' The Data Files Directory must contain the following files:   *
        ' mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str		       *
        ' **************************************************************
        Const dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data"

        'Set default information
        Company.Text = "ABC Company"
        Address.Text = "201 10th St."
        City.Text = "Las Vegas"
        State.Text = "NV"
        Zip.Text = "89101"
        parseAddress.Text = "201 10th St."
        parseAddressLL.Text = "Las Vegas, NV 89101-5519"
        sAddress.Text = "Main St."
        sZip.Text = "89101"
        zCity.Text = "Las Vegas"
        zState.Text = "NV"
        zZip.Text = "89101"

        '***********Initializing ADDRESS CHECK Interface*************
        'Set License
        addrObj.SetLicenseString(dLICENSE)
        'Set path to the data files
        addrObj.SetPathToUSFiles(dFILELOC)

        'CASS required add-ons for highest level of validation. Should be used by non-demo users.
        'addrObj.SetPathToDPVDataFiles(dFILELOC)
        'addrObj.SetPathToLACSLinkDataFiles(dFILELOC)
        'addrObj.SetPathToSuiteLinkDataFiles(dFILELOC)

        'addrObj.SetPathToRBDIFiles(dFILELOC)              'Delivery Indicator Add-on (Residence or Business)
        'addrObj.SetPathToCanadaFiles(dFILELOC)           'Canadian Address Validation Add-on
        'addrObj.SetPathToSuiteFinderDataFiles(dFILELOC)   'AddressPlus Add-on (appends residential suites)

        'Now we will Initialize the object
        If (addrObj.InitializeDataFiles() <> 0) Then
            'If we were not successful then we need to return our error
            InitErrorString.Text = addrObj.GetInitializeErrorString()
        Else
            'Let's give them the good news
            InitErrorString.Text = addrObj.GetInitializeErrorString()
            'Let's get the US database date.
            DatabaseDate.Text = addrObj.GetDatabaseDate()
            ExpDate.Text = addrObj.GetExpirationDate()
            BuildNum.Text = addrObj.GetBuildNumber()
        End If

        '****Initialize PARSE  Interface****
        '   Load Suffix File, not necessary but highly recommended
        '   Will increase parse accuracy with misspelled suffixes
        parseObj.Initialize(dFILELOC)
        BuildNumParse.Text = parseObj.GetBuildNumber()

        '****Initialize STREETDATA Interface****
        streetObj.SetLicenseString(dLICENSE)
        If (streetObj.Initialize(dFILELOC, dFILELOC, "")) Then
            ' Initialize failed
            InitErrorStringStreet.Text = streetObj.GetInitializeErrorString()
        Else
            'Get information for form
            BuildNumStreet.Text = streetObj.GetBuildNumber()
            DatabaseDateStreet.Text = streetObj.GetDatabaseDate()
            InitErrorStringStreet.Text = streetObj.GetInitializeErrorString()
        End If


        '****Initialize ZIPDATA Interface****
        'Set License
        zipObj.SetLicenseString(dLICENSE)
        If zipObj.Initialize(dFILELOC, dFILELOC, "") Then
            ' Initialize failed
            InitErrorStringZip.Text = zipObj.GetInitializeErrorString()
        Else
            ' Initialize successful, get information for form
            BuildNumZip.Text = zipObj.GetBuildNumber()
            DatabaseDateZip.Text = zipObj.GetDatabaseDate()
            InitErrorStringZip.Text = zipObj.GetInitializeErrorString()
        End If
    End Sub
    Private Sub Form1_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        addrObj = Nothing
        parseObj = Nothing
        streetObj = Nothing
        zipObj = Nothing
    End Sub
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim ResultsString As String
        Dim OutString As String

        'Clearing Properties from addrObj
        addrObj.ClearProperties()

        'Loading values from Form into Object.
        addrObj.SetCompany(Company.Text)
        addrObj.SetAddress(Address.Text)
        addrObj.SetAddress2(Address2.Text)
        addrObj.SetCity(City.Text)
        addrObj.SetState(State.Text)
        addrObj.SetPlus4(Plus4.Text)
        addrObj.SetZip(Zip.Text)
        addrObj.SetLastName(LastName.Text)

        'Verifying address.  Note: VerifyAddress() will return TRUE if successful.
        addrObj.VerifyAddress()

        'Loading form with captured and corrected data.
        cCompany.Text = addrObj.GetCompany
        cAddress.Text = addrObj.GetAddress
        cAddress2.Text = addrObj.GetAddress2
        cSuite.Text = addrObj.GetSuite
        cCity.Text = addrObj.GetCity
        cState.Text = addrObj.GetState
        cZip.Text = addrObj.GetZip
        cPlus4.Text = addrObj.GetPlus4

        
        ' results are returned as a delimited string, so we parse it here...
        ResultsString = addrObj.GetResults()
        OutString = ""
        If (InStr(1, ResultsString, "AS")) Then
            ' address was verified
            If (InStr(1, ResultsString, "AS01")) Then
                OutString = OutString + "AS01: Full Address Matched to Postal Database and is deliverable " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS02")) Then
                OutString = OutString + "AS02: Address matched to USPS database but a suite was missing Or invalid" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS03")) Then
                OutString = OutString + "AS03: Valid Physical Address, not Serviced by the USPS " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS09")) Then
                OutString = OutString + "AS09: Foreign Postal Code Detected " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS10")) Then
                OutString = OutString + "AS10: Address Matched to CMRA" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS13")) Then
                OutString = OutString + "AS13: Address has been Updated by LACSLink " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS14")) Then
                OutString = OutString + "AS14: Suite Appended by SuiteLink " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS15")) Then
                OutString = OutString + "AS15: Suite Appended by SuiteFinder " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS16")) Then
                OutString = OutString + "AS16: Address is vacant." + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS17")) Then
                OutString = OutString + "AS17: Alternate delivery." + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS18")) Then
                OutString = OutString + "AS18: Artificially created adresses detected,DPV processing terminated at this point" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS20")) Then
                OutString = OutString + "AS20: Address Deliverable by USPS only " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS21")) Then
                OutString = OutString + "AS21: Alternate Address Suggestion Found" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS22")) Then
                OutString = OutString + "AS22: No Alternate Address Suggestion Found + vbCrLf"
            End If
            If (InStr(1, ResultsString, "AS23")) Then
                OutString = OutString + "AS23: Extraneous information found " + vbCrLf
            End If

            txtResultCodes.ForeColor = Color.Green
        End If
        If (InStr(1, ResultsString, "AE")) Then
            ' there was an error in verifying the address
            If (InStr(1, ResultsString, "AE01")) Then
                OutString = OutString + "AE01: Zip Code Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE02")) Then
                OutString = OutString + "AE02: Unknown Street Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE03")) Then
                OutString = OutString + "AE03: Component Mismatch Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE04")) Then
                OutString = OutString + "AE04: Non-Deliverable Address Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE05")) Then
                OutString = OutString + "AE05: Multiple Match Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE06")) Then
                OutString = OutString + "AE06: Early Warning System Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE07")) Then
                OutString = OutString + "AE07: Missing Minimum Address Input " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE08")) Then
                OutString = OutString + "AE08: Suite Range Invalid Error" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE09")) Then
                OutString = OutString + "AE09: Suite Range Missing Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE10")) Then
                OutString = OutString + "AE10: Primary Range Invalid Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE11")) Then
                OutString = OutString + "AE11: Primary Range Missing Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE12")) Then
                OutString = OutString + "AE12: PO, HC, or RR Box Number Invalid " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE13")) Then
                OutString = OutString + "AE13: PO, HC, or RR Box Number Missing " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE14")) Then
                OutString = OutString + "AE14: CMRA Secondary Missing Error" + vbCrLf
            End If

            ' program can not attempt address lookup
            If (InStr(1, ResultsString, "AE15")) Then
                OutString = OutString + "AE15: Demo Mode " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE16")) Then
                OutString = OutString + "AE16: Expired Database" + vbCrLf
            End If

            If (InStr(1, ResultsString, "AE17")) Then
                OutString = OutString + "AE17: Unnecessary Suite Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE19")) Then
                OutString = OutString + "AE19: Max time for FindSuggestion exceeded " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE20")) Then
                OutString = OutString + "AE20: FindSuggestion cannot be used" + vbCrLf
            End If

            txtResultCodes.ForeColor = Color.Red
        End If

        ' a change was made to the address
        If (InStr(1, ResultsString, "AC01")) Then
            OutString = OutString + "AC01: ZIP Code Change " + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC02")) Then
            OutString = OutString + "AC02: State Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC03")) Then
            OutString = OutString + "AC03: City Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC04")) Then
            OutString = OutString + "AC04: Base/Alternate Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC05")) Then
            OutString = OutString + "AC05: Alias Name Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC06")) Then
            OutString = OutString + "AC06: Address1/Address2 Swap" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC07")) Then
            OutString = OutString + "AC07: Address1/Company Swap" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC08")) Then
            OutString = OutString + "AC08: Plus4 Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC09")) Then
            OutString = OutString + "AC09: Urbanization Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC10")) Then
            OutString = OutString + "AC10: Street Name Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC11")) Then
            OutString = OutString + "AC11: Street Suffix Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC12")) Then
            OutString = OutString + "AC12: Street Directional Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC13")) Then
            OutString = OutString + "AC13: Suite Name Change" + vbCrLf
        End If

        txtResultCodes.Text = OutString

        'Loading the comment text field with extra data and flags that are set when
        'the VerifyAddress Method is called.

        comments.Text += "CarrierRoute=" + addrObj.GetCarrierRoute + vbCrLf
        comments.Text += "DeliveryPointCode=" + addrObj.GetDeliveryPointCode + vbCrLf
        comments.Text += "DeliveryPointCheckDigit=" + addrObj.GetDeliveryPointCheckDigit + vbCrLf
        comments.Text += "DPVFootnotes=" + addrObj.GetDPVFootnotes + vbCrLf
        comments.Text += vbCrLf
        comments.Text += "AddressTypeCode=" + addrObj.GetAddressTypeCode + vbCrLf
        comments.Text += "AddressTypeString=" + addrObj.GetAddressTypeString + vbCrLf
        comments.Text += "CityAbbreviation=" + addrObj.GetCityAbbreviation + vbCrLf
        comments.Text += "CountyName=" + addrObj.GetCountyName + vbCrLf
        comments.Text += "CountyFips=" + addrObj.GetCountyFips + vbCrLf
        comments.Text += "CountryCode=" + addrObj.GetCountryCode + vbCrLf
        comments.Text += "CongressionalDistrict=" + addrObj.GetCongressionalDistrict + vbCrLf
        comments.Text += "TimeZone=" + addrObj.GetTimeZone + vbCrLf
        comments.Text += "TimeZoneCode=" + addrObj.GetTimeZoneCode + vbCrLf
        comments.Text += "Urbanization=" + addrObj.GetUrbanization + vbCrLf
        comments.Text += "Zip=" + addrObj.GetZip + vbCrLf
        comments.Text += "ZipType=" + addrObj.GetZipType + vbCrLf
        comments.Text += vbCrLf
        comments.Text += "ParsedAddressRange=" + addrObj.GetParsedAddressRange + vbCrLf
        comments.Text += "ParsedPreDirection=" + addrObj.GetParsedPreDirection + vbCrLf
        comments.Text += "ParsedStreetName=" + addrObj.GetParsedStreetName + vbCrLf
        comments.Text += "ParsedSuffix=" + addrObj.GetParsedSuffix + vbCrLf
        comments.Text += "ParsedPostDirection=" + addrObj.GetParsedPostDirection + vbCrLf
        comments.Text += "ParsedSuiteName=" + addrObj.GetParsedSuiteName + vbCrLf
        comments.Text += "ParsedSuiteRange=" + addrObj.GetParsedSuiteRange + vbCrLf
        comments.Text += "ParsedPrivateMailboxName=" + addrObj.GetParsedPrivateMailboxName + vbCrLf
        comments.Text += "ParsedPrivateMailboxNumber=" + addrObj.GetParsedPrivateMailboxNumber + vbCrLf
        comments.Text += "ParsedGarbage=" + addrObj.GetParsedGarbage + vbCrLf
        comments.Text += vbCrLf
        comments.Text += "MSA=" + addrObj.GetMsa + vbCrLf
        comments.Text += "PMSA=" + addrObj.GetPmsa + vbCrLf
        comments.Text += "CMRA=" + addrObj.GetCMRA + vbCrLf
        comments.Text += "PrivateMailbox=" + addrObj.GetPrivateMailbox + vbCrLf
        comments.Text += vbCrLf
        comments.Text += "ELotOrder=" + addrObj.GetELotOrder + vbCrLf
        comments.Text += "ELotNumber=" + addrObj.GetELotNumber + vbCrLf
        comments.Text += "LACS=" + addrObj.GetLACS + vbCrLf
        comments.Text += "LACSLinkIndicator=" + addrObj.GetLACSLinkIndicator + vbCrLf
        comments.Text += "LACSLinkReturnCode=" + addrObj.GetLACSLinkReturnCode + vbCrLf
        comments.Text += "SuiteLinkReturnCode=" + addrObj.GetSuiteLinkReturnCode + vbCrLf
        comments.Text += "EWS=" + addrObj.GetEWSFlag + vbCrLf
        comments.Text += "RBDI=" + addrObj.GetRBDI + vbCrLf

    End Sub



    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        'Calling Parse(), the first parsing of the address text from form
        'Must be run before ParseNext(). 
        parseObj.Parse(parseAddress.Text)

        'Setting parseFlag to allow ParseNext() to be called
        parseFlag = 1

        'Get parsed data for form
        Range.Text = parseObj.GetRange
        PostDirection.Text = parseObj.GetPostDirection
        PreDirection.Text = parseObj.GetPreDirection
        Suffix.Text = parseObj.GetSuffix
        Street.Text = parseObj.GetStreetName
        SuiteName.Text = parseObj.GetSuiteName
        SuiteNumber.Text = parseObj.GetSuiteNumber
        Garbage.Text = parseObj.GetGarbage

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        'Calling ParseNext() to get all combinations of string tokens
        'Checking is parse() has been called already
        If (parseFlag = 1) Then
            'Checking if ParseNext() is available for new parse combo.
            If (parseObj.ParseNext()) Then
                'Success, get parsed information
                Range.Text = parseObj.GetRange
                PostDirection.Text = parseObj.GetPostDirection
                PreDirection.Text = parseObj.GetPreDirection
                Suffix.Text = parseObj.GetSuffix
                Street.Text = parseObj.GetStreetName
                SuiteName.Text = parseObj.GetSuiteName
                SuiteNumber.Text = parseObj.GetSuiteNumber
                Garbage.Text = parseObj.GetGarbage
            Else
                'End of parse combinations, display notice.
                MsgBox("Finshed reparsing.")
            End If
        Else
            'Failed check, display warning.
            MsgBox("Run Parse first.")
        End If
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        'Calling LastLineParse for inputed last line
        parseObj.LastLineParse(parseAddressLL.Text)
        'Get data to display on form
        pCity.Text = parseObj.GetCity
        pState.Text = parseObj.GetState
        pZip.Text = parseObj.GetZip
        pPlus4.Text = parseObj.GetPlus4

    End Sub


    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        'Creating variable to hold only the parsed StreetName.
        Dim pStreet
        Dim sOutput = ""

        'Parsing Address value once to obtain only the Street Name and storing result.
        'Only necessary if user inputs full address line and not just street name.
        parseObj.Parse(sAddress.Text)
        'Storing parse to temp
        pStreet = parseObj.GetStreetName

        'Calling and testing FindStreet() to find the first street range found with input data.
        'FindStreet() Returns FALSE is no street record is found.
        If (streetObj.FindStreet(pStreet, sZip.Text, "0") = 0) Then
            'FindStreet() did not find the specified street in the zip code, show warning.
            'Check if your street in address is spelled correctly.  If you have reparsed manually, it may
            'have scrambled the input address so it would not be recognized by FindStreet().
            MsgBox("Unable to locate specific Street Name in Zip Code.")
        Else
            'Successful, recognized street and zip.
            'Filling and formating comment form with initial results.
            sOutput = streetObj.GetPrimaryRangeLow + "-"
            sOutput += streetObj.GetPrimaryRangeHigh + " "
            sOutput += streetObj.GetPrimaryRangeOddEven + " "
            sOutput += streetObj.GetPreDirection + " "
            sOutput += streetObj.GetStreetName + " "
            sOutput += streetObj.GetSuffix + " "
            sOutput += streetObj.GetPostDirection + " "
            If (streetObj.GetSuiteName = "") Then
                sOutput += "    "
            Else
                sOutput += streetObj.GetSuiteName + " "
            End If
            If (streetObj.GetSuiteRangeLow = "") Then
                sOutput += "  "
            Else
                sOutput += streetObj.GetSuiteRangeLow.Trim + " "
            End If
            If (streetObj.GetSuiteRangeHigh = "") Then
                sOutput += "  "
            Else
                sOutput += streetObj.GetSuiteRangeHigh.Trim + " "
            End If
            sOutput += streetObj.GetSuiteRangeOddEven + " "
            sOutput += streetObj.GetZip + " "
            sOutput += streetObj.GetPlus4Low + "-"
            sOutput += streetObj.GetPlus4High + vbCrLf



            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindStreetNext() returns TRUE if next record exists
            While (streetObj.FindStreetNext() > 0)
                'Filling comment form with next result.
                sOutput += streetObj.GetPrimaryRangeLow + "-"
                sOutput += streetObj.GetPrimaryRangeHigh + " "
                sOutput += streetObj.GetPrimaryRangeOddEven + " "
                sOutput += streetObj.GetPreDirection + " "
                sOutput += streetObj.GetStreetName + " "
                sOutput += streetObj.GetSuffix + " "
                sOutput += streetObj.GetPostDirection + " "
                If (streetObj.GetSuiteName = "") Then
                    sOutput += "    "
                Else
                    sOutput += streetObj.GetSuiteName + " "
                End If
                If (streetObj.GetSuiteRangeLow = "") Then
                    sOutput += "  "
                Else
                    sOutput += streetObj.GetSuiteRangeLow.Trim + "-"
                End If
                If (streetObj.GetSuiteRangeHigh = "") Then
                    sOutput += "  "
                Else
                    sOutput += streetObj.GetSuiteRangeHigh.Trim + " "
                End If
                sOutput += streetObj.GetSuiteRangeOddEven + " "
                sOutput += streetObj.GetZip + " "
                sOutput += streetObj.GetPlus4Low + "-"
                sOutput += streetObj.GetPlus4High + vbCrLf
            End While
        End If
        scomments.Text = sOutput
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        Dim zOutput
        'Call and test FindCityInState() to find first city in specified state.
        'FindCityInState() returns true if record is found.
        If zipObj.FindCityInState(zCity.Text, zState.Text) Then
            'Successful.  Filling comment form with initial results.
            zOutput = zipObj.GetCity + " " + zipObj.GetState + vbCrLf

            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindCityinStateNext() returns TRUE if next record exists.
            While (zipObj.FindCityInStateNext())
                'Filling comment form with next result.
                zOutput += zipObj.GetCity + " " + zipObj.GetState + vbCrLf
            End While
            zcomments.Text = zOutput
        Else
            'Not successful, display warning.
            MsgBox("Could Not Find City in State.")
        End If
    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        Dim zOutput
        'Call and test ZipInCity() to find first zip code in specified city and state.
        'ZipInCity() returns true if record is found.
        If (zipObj.FindZipInCity(zCity.Text, zState.Text)) Then
            'Successful.  Filling comment form with initial results.
            zOutput = zipObj.GetZip + " "
            zOutput += zipObj.GetCity + " "
            zOutput += zipObj.GetState + " "
            zOutput += zipObj.GetCountyFips + " "
            zOutput += zipObj.GetCountyName + " "
            zOutput += zipObj.GetLatitude + " "
            zOutput += zipObj.GetLongitude + " "
            zOutput += zipObj.GetTimeZone + " "
            zOutput += zipObj.GetLastLineIndicator + vbCrLf

            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindZipInCityNext() returns TRUE if next record exists.
            While (zipObj.FindZipInCityNext())
                'Filling comment form with next result.
                zOutput += zipObj.GetZip + " "
                zOutput += zipObj.GetCity + " "
                zOutput += zipObj.GetState + " "
                zOutput += zipObj.GetCountyFips + " "
                zOutput += zipObj.GetCountyName + " "
                zOutput += zipObj.GetLatitude + " "
                zOutput += zipObj.GetLongitude + " "
                zOutput += zipObj.GetTimeZone + " "
                zOutput += zipObj.GetLastLineIndicator + vbCrLf
            End While
            zcomments.Text = zOutput
        Else
            'Not successful, display warning.
            MsgBox("Could Not Find Zip Code in City.")
        End If

    End Sub

    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click
        Dim zOutput
        'Call and test FindZip() to find first zip code in specified city and state.
        'FindZip() returns true if record is found.
        If (zipObj.FindZip(zZip.Text, 0)) Then
            'Successful.  Creating header for output.
            'Filling comment form with initial results.
            zOutput = zipObj.GetZip + " "
            zOutput += zipObj.GetCity + " "
            zOutput += zipObj.GetState + " "
            zOutput += zipObj.GetAreaCode + " "
            zOutput += zipObj.GetCountyFips + " "
            zOutput += zipObj.GetCountyName + " "
            zOutput += zipObj.GetLatitude + " "
            zOutput += zipObj.GetLongitude + " "
            zOutput += zipObj.GetLastLineIndicator + vbCrLf
            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindZipNext() returns TRUE if next record exists.
            While (zipObj.FindZipNext())
                'Filling comment form with next result.
                zOutput += zipObj.GetZip + " "
                zOutput += zipObj.GetCity + " "
                zOutput += zipObj.GetState + " "
                zOutput += zipObj.GetAreaCode + " "
                zOutput += zipObj.GetCountyFips + " "
                zOutput += zipObj.GetCountyName + " "
                zOutput += zipObj.GetLatitude + " "
                zOutput += zipObj.GetLongitude + " "
                zOutput += zipObj.GetLastLineIndicator + vbCrLf
            End While
            zcomments.Text = zOutput
        Else
            'Not successful, display notice.
            MsgBox("Could Not Find Zip Code.")
        End If

    End Sub


End Class